"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ColumnsService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const column_entity_1 = require("./entities/column.entity");
const mongoose_2 = require("mongoose");
let ColumnsService = class ColumnsService {
    columnModel;
    constructor(columnModel) {
        this.columnModel = columnModel;
    }
    async createColumn(percent) {
        const column = await this.columnModel.create({ percent, finalAmount: 0 });
        if (!column)
            throw new common_1.BadRequestException("خطا در ایجاد ستون!");
        return column;
    }
    async getColumns() {
        const columns = await this.columnModel.find();
        if (columns) {
            console.log([{ _id: "5336366", percent: 0 }, ...columns, { _id: "7yt689866", percent: 0 }]);
            return [{ _id: "5336366", percent: "created", activate: true }, ...columns, { _id: "7yt689866", percent: "completed", activate: true }];
        }
        return columns;
    }
    async deleteColumn(id) {
        return await this.columnModel.findByIdAndDelete(id);
    }
    async changeActivate(id, activate) {
        const column = await this.columnModel.findByIdAndUpdate(id, { activate: !activate });
        return column;
    }
    async changeFinalAmount(id, finalAmount) {
        const column = await this.columnModel.findByIdAndUpdate(id, { finalAmount });
        if (!column)
            throw new common_1.NotFoundException("ستون مورد نظر یافت نشد!");
        return column;
    }
    async changeTotalAmount(id, totalAmount) {
        const column = await this.columnModel.findByIdAndUpdate(id, { totalAmount });
        if (!column)
            throw new common_1.NotFoundException("ستون مورد نظر یافت نشد!");
        return column;
    }
};
exports.ColumnsService = ColumnsService;
exports.ColumnsService = ColumnsService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(column_entity_1.Column.name)),
    __metadata("design:paramtypes", [mongoose_2.Model])
], ColumnsService);
//# sourceMappingURL=columns.service.js.map