"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreatedUserService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const created_user_entity_1 = require("./entities/created-user.entity");
const mongoose_2 = require("mongoose");
const users_service_1 = require("../users/users.service");
let CreatedUserService = class CreatedUserService {
    createdUserModel;
    usersService;
    constructor(createdUserModel, usersService) {
        this.createdUserModel = createdUserModel;
        this.usersService = usersService;
    }
    async createUserProvisional(userId, type) {
        const userExisting = await this.createdUserModel.findOne({ userId, type });
        if (!userExisting) {
            const nowDate = Date.now();
            const oneWeak = 7 * 24 * 60 * 60 * 1000;
            const expired = new Date(nowDate + oneWeak);
            const user = await this.createdUserModel.create({ userId, type, expired });
            if (!user)
                throw new common_1.BadRequestException("خطا در ایجاد کاربر!");
            return user;
        }
        else {
            return userExisting;
        }
    }
    async getUsers(type) {
        const users = await this.createdUserModel.find({ type });
        if (!users)
            throw new common_1.NotFoundException('کابری یافت نشد!');
        const now = new Date();
        if (users.length != 0) {
            const usersFiltered = users.filter(item => !(item.expired < now));
            const resultUsers = await Promise.all(usersFiltered.map(async (user) => {
                const response = await this.usersService.findUserById(user.userId);
                return { user: response };
            }));
            return resultUsers;
        }
        else {
            return users;
        }
    }
    async deleteWithUserId(userId, type) {
        const user = await this.createdUserModel.findOneAndDelete({ userId, type });
        return user;
    }
};
exports.CreatedUserService = CreatedUserService;
exports.CreatedUserService = CreatedUserService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(created_user_entity_1.CreatedUser.name)),
    __param(1, (0, common_1.Inject)((0, common_1.forwardRef)(() => users_service_1.UsersService))),
    __metadata("design:paramtypes", [mongoose_2.Model,
        users_service_1.UsersService])
], CreatedUserService);
//# sourceMappingURL=created-user.service.js.map