"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvestmentController = void 0;
const common_1 = require("@nestjs/common");
const investment_service_1 = require("./investment.service");
let InvestmentController = class InvestmentController {
    investmentService;
    constructor(investmentService) {
        this.investmentService = investmentService;
    }
    async createInvestment(body) {
        return await this.investmentService.createInvestment(body.userId, body.percent, Number(body.time), body.type, body.amount);
    }
    async getAll() {
        return await this.investmentService.getAll();
    }
    async getUserInvestments(userId) {
        return await this.investmentService.getUserInvestments(userId);
    }
    async deleteInvestment(id) {
        return await this.investmentService.deleteInvestment(id);
    }
    async createOrUpdateInvestment(body) {
        console.log(body);
        return await this.investmentService.createOrUpdateInvestment(body.id, body.userId, body.type, body.fromColumn, body.endColumn);
    }
    async updateEndTimeInvestment(body) {
        console.log(body);
        return await this.investmentService.updateEndTimeInvestment(body.type, body.userId, Number(body.time), body.endColumn, body.amount);
    }
};
exports.InvestmentController = InvestmentController;
__decorate([
    (0, common_1.Post)('create'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], InvestmentController.prototype, "createInvestment", null);
__decorate([
    (0, common_1.Get)(''),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], InvestmentController.prototype, "getAll", null);
__decorate([
    (0, common_1.Get)('user/:userId'),
    __param(0, (0, common_1.Param)('userId')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], InvestmentController.prototype, "getUserInvestments", null);
__decorate([
    (0, common_1.Delete)('delete/:id'),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], InvestmentController.prototype, "deleteInvestment", null);
__decorate([
    (0, common_1.Patch)('create-or-update'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], InvestmentController.prototype, "createOrUpdateInvestment", null);
__decorate([
    (0, common_1.Patch)('update/time'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], InvestmentController.prototype, "updateEndTimeInvestment", null);
exports.InvestmentController = InvestmentController = __decorate([
    (0, common_1.Controller)('investment'),
    __metadata("design:paramtypes", [investment_service_1.InvestmentService])
], InvestmentController);
//# sourceMappingURL=investment.controller.js.map