"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvestmentService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const investment_entity_1 = require("./entities/investment.entity");
const mongoose_2 = require("mongoose");
const users_service_1 = require("../users/users.service");
const created_user_service_1 = require("../created-user/created-user.service");
const units_service_1 = require("../units/units.service");
const process_settings_service_1 = require("../process-settings/process-settings.service");
let InvestmentService = class InvestmentService {
    investmentModel;
    userService;
    createdUserService;
    unitsService;
    processSettingsService;
    constructor(investmentModel, userService, createdUserService, unitsService, processSettingsService) {
        this.investmentModel = investmentModel;
        this.userService = userService;
        this.createdUserService = createdUserService;
        this.unitsService = unitsService;
        this.processSettingsService = processSettingsService;
    }
    async createInvestment(userId, percent, time, type, amount) {
        const nowDate = Date.now();
        const newDate = Number(time) * 30 * 24 * 60 * 60 * 1000;
        const endTime = new Date(nowDate + newDate);
        const deadline = await this.processSettingsService.getDeadlineTime();
        const deadlineTime = new Date(Date.now() + deadline);
        const investment = await this.investmentModel.create({ userId, percent, time: Number(time), endTime, type, amount,
            division: 0,
            benefit: 0,
            totalBenefit: 0,
            status: 'pending',
            creationDeadline: deadlineTime,
        });
        if (!investment)
            throw new common_1.BadRequestException('خطا در ایجاد درخواست!');
        const userProvisional = await this.createdUserService.deleteWithUserId(userId, type);
        return { investment, userProvisional };
    }
    async getAll() {
        const investments = await this.investmentModel.find();
        const result = await Promise.all(investments.map(async (item) => {
            const user = await this.userService.findUserById(item.userId);
            return { user, investment: item };
        }));
        return result;
    }
    async getUserInvestments(userId) {
        const investments = await this.investmentModel.find({ userId }).sort({ createdAt: -1 });
        if (!investments)
            throw new common_1.NotFoundException('درخواست مورد نظر یافت نشد!');
        let groupedInvestments = [];
        let typeList = [];
        investments.forEach((item) => {
            if (groupedInvestments.length == 0) {
                groupedInvestments = [{ type: item.type, investments: [item] }];
                typeList = [{ type: item.type, totalBenefitAmount: item.totalBenefit, totalInvestmentAmount: item.amount }];
            }
            else if (groupedInvestments.find((itemSaved) => itemSaved.type == item.type)) {
                const index = groupedInvestments.findIndex((itemSaved) => itemSaved.type == item.type);
                groupedInvestments[index].investments.push(item);
                typeList[index].totalBenefitAmount += item.totalBenefit;
                typeList[index].totalInvestmentAmount += item.amount;
            }
            else {
                groupedInvestments.push({ type: item.type, investments: [item] });
                typeList.push({ type: item.type, totalBenefitAmount: item.totalBenefit, totalInvestmentAmount: item.amount });
            }
        });
        return { investments, groupedInvestments, typeList };
    }
    async getInvestmentWithTypeAndPercent(type, percent) {
        const investments = await this.investmentModel.find({ type, percent, status: "created" });
        const result = await Promise.all(investments.map(async (item) => {
            const user = await this.userService.findUserById(item.userId);
            return { user, investment: item };
        }));
        return result;
    }
    async getInvestmentCompleted(type) {
        const investments = await this.investmentModel.find({ type, status: 'completed' });
        const result = await Promise.all(investments.map(async (item) => {
            const user = await this.userService.findUserById(item.userId);
            return { user, investment: item };
        }));
        return result;
    }
    async getInvestmentPending(type) {
        const investments = await this.investmentModel.find({ type, status: 'pending' });
        const result = await Promise.all(investments.map(async (item) => {
            const user = await this.userService.findUserById(item.userId);
            return { user, investment: item };
        }));
        return result;
    }
    async updateEndTimeInvestment(type, userId, time, endColumn, amount) {
        const nowDate = Date.now();
        const newDate = Number(time) * 30 * 24 * 60 * 60 * 1000;
        const endTime = new Date(nowDate + newDate);
        const investment = await this.investmentModel.create({ type, userId, time, percent: Number(endColumn), endTime, amount, benefit: 0, totalBenefit: 0 });
        if (!investment)
            throw new common_1.NotFoundException('درخواست مورد نظر یافت نشد!');
        return investment;
    }
    async updateInvestment(id, userId, percent, time, type, amount) {
        const nowDate = Date.now();
        const newDate = Number(time) * 30 * 24 * 60 * 60 * 1000;
        const endTime = new Date(nowDate + newDate);
        const investment = await this.investmentModel.findById(id);
        if (!investment) {
            const newInvestment = this.investmentModel.create({ userId, percent, time, endTime, type, amount });
            return newInvestment;
        }
        else {
            if (investment.status == "completed" && time != investment.time) {
                investment.percent = percent;
                investment.time = time;
                investment.endTime = endTime;
                investment.type = type;
                investment.amount = amount;
                investment.status = "created";
                await investment.save();
            }
            else {
                investment.percent = percent;
                investment.time = time;
                investment.endTime = endTime;
                investment.type = type;
                investment.amount = amount;
                await investment.save();
            }
        }
        return investment;
    }
    async deleteInvestment(id) {
        const investment = await this.investmentModel.findByIdAndDelete(id);
        if (!investment)
            throw new common_1.BadRequestException("خطا در حذف !");
        return investment;
    }
    async createOrUpdateInvestment(id, userId, type, fromColumn, endColumn) {
        if (fromColumn == 'created') {
            const userProvisional = await this.createdUserService.deleteWithUserId(userId, type);
            if (endColumn != 'completed') {
                const investment = await this.investmentModel.create({ userId, percent: Number(endColumn) });
                const updateAmount = await this.unitsService.updateColumnAmountAddItem(type, endColumn, investment?.amount || 0);
                return { investment, userProvisional, updateAmount };
            }
        }
        else if (endColumn == "created") {
            const userProvisional = await this.createdUserService.createUserProvisional(userId, type);
            if (!userProvisional)
                throw new common_1.BadRequestException('خطا در جابه جایی درخواست!');
            const investmentDeleted = await this.investmentModel.findByIdAndDelete(id);
            const updateAmount = await this.unitsService.updateColumnAmountItemLeaveColumn(type, fromColumn, investmentDeleted?.amount || 0);
            return { investmentDeleted, userProvisional, updateAmount };
        }
        else if (endColumn == "completed") {
            const endTime = new Date();
            const investmentDeleted = await this.investmentModel.findByIdAndUpdate(id, { status: "completed", endTime });
            const updateAmount = await this.unitsService.updateColumnAmountItemLeaveColumn(type, fromColumn, investmentDeleted?.amount || 0);
            return { investmentDeleted, updateAmount };
        }
        else {
            const investmentUpdated = await this.investmentModel.findByIdAndUpdate(id, { percent: Number(endColumn) }, { new: true });
            const updateAmountFrom = await this.unitsService.updateColumnAmountItemLeaveColumn(type, fromColumn, investmentUpdated?.amount || 0);
            const updateAmountEnd = await this.unitsService.updateColumnAmountAddItem(type, endColumn, investmentUpdated?.amount || 0);
            return { investmentUpdated, updateAmountFrom, updateAmountEnd };
        }
    }
    async updateInvestmentsValues(type, percent, totalAmount, benefit) {
        const investments = await this.investmentModel.find({ type, percent });
        if (!investments)
            throw new common_1.NotFoundException("موردی یافت نشد!");
        await Promise.all(investments.map(async (item) => {
            if (item?.division != undefined && item?.benefit != undefined && item?.totalBenefit != undefined && item?.amount != undefined) {
                item.division = Number(((item.amount / totalAmount) * 100).toFixed(2));
                item.benefit = Number(((benefit / 100) * ((item.amount / totalAmount) * 100)).toFixed(2));
                return await item.save();
            }
        }));
    }
    async updateInvestmentsValuesWithApplyReset(type, percent) {
        const investments = await this.investmentModel.updateMany({ type, percent }, [
            {
                $set: {
                    totalBenefit: { $round: [{ $add: ["$totalBenefit", "$benefit"] }, 2] },
                    benefit: 0
                }
            }
        ]);
        return investments;
    }
};
exports.InvestmentService = InvestmentService;
exports.InvestmentService = InvestmentService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(investment_entity_1.Investment.name)),
    __param(1, (0, common_1.Inject)((0, common_1.forwardRef)(() => users_service_1.UsersService))),
    __param(3, (0, common_1.Inject)((0, common_1.forwardRef)(() => units_service_1.UnitsService))),
    __metadata("design:paramtypes", [mongoose_2.Model,
        users_service_1.UsersService,
        created_user_service_1.CreatedUserService,
        units_service_1.UnitsService,
        process_settings_service_1.ProcessSettingsService])
], InvestmentService);
//# sourceMappingURL=investment.service.js.map