"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnitsController = void 0;
const common_1 = require("@nestjs/common");
const units_service_1 = require("./units.service");
let UnitsController = class UnitsController {
    unitsService;
    constructor(unitsService) {
        this.unitsService = unitsService;
    }
    async createUnits(body) {
        return await this.unitsService.createUnit(body.type);
    }
    async getAllUnits() {
        return await this.unitsService.getUnits();
    }
    async getColumnsOfUnit(type) {
        return await this.unitsService.getColumnsOfUnit(type);
    }
    async createColumnOfUnit(body) {
        return await this.unitsService.createColumnOfUnit(body.type, body.title);
    }
    async changeActivateColumn(body) {
        return await this.unitsService.changeActivateColumn(body.type, body.titleColumn);
    }
    async autoUpdateAmountsColumn(body) {
        return await this.unitsService.autoUpdateAmountsColumn(body.type, body.key, body.titleColumn);
    }
    async updateFinalAmountColumn(body) {
        console.log(body.columnsUpdate);
        return await this.unitsService.updateFinalAmountColumn(body.type, body.columnsUpdate);
    }
    async updateFinalAmountColumnAuto(body) {
        return await this.unitsService.updateFinalAmountWithOnChange(body.type, body.titleColumn, body.finalAmount);
    }
    async deleteColumn(body) {
        return await this.unitsService.deleteColumn(body.type, body.titleColumn);
    }
    async updateAllAmountColumn(body) {
        return await this.unitsService.updateAllAmountColumn(body.type);
    }
};
exports.UnitsController = UnitsController;
__decorate([
    (0, common_1.Post)('create'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], UnitsController.prototype, "createUnits", null);
__decorate([
    (0, common_1.Get)(''),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], UnitsController.prototype, "getAllUnits", null);
__decorate([
    (0, common_1.Get)('columns/:type'),
    __param(0, (0, common_1.Param)('type')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], UnitsController.prototype, "getColumnsOfUnit", null);
__decorate([
    (0, common_1.Patch)('create/columns'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], UnitsController.prototype, "createColumnOfUnit", null);
__decorate([
    (0, common_1.Patch)('update/activate'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], UnitsController.prototype, "changeActivateColumn", null);
__decorate([
    (0, common_1.Patch)('update/amounts-kv'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], UnitsController.prototype, "autoUpdateAmountsColumn", null);
__decorate([
    (0, common_1.Patch)('update/final-amount'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], UnitsController.prototype, "updateFinalAmountColumn", null);
__decorate([
    (0, common_1.Patch)('update/final-amount-auto'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], UnitsController.prototype, "updateFinalAmountColumnAuto", null);
__decorate([
    (0, common_1.Patch)('delete/column'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], UnitsController.prototype, "deleteColumn", null);
__decorate([
    (0, common_1.Patch)('update/all'),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], UnitsController.prototype, "updateAllAmountColumn", null);
exports.UnitsController = UnitsController = __decorate([
    (0, common_1.Controller)('units'),
    __metadata("design:paramtypes", [units_service_1.UnitsService])
], UnitsController);
//# sourceMappingURL=units.controller.js.map