import { CreateUserDto } from './dto/create-user.dto';
import { UpdateUserDto } from './dto/update-user.dto';
import { User, UserDocument } from './entities/user.entity';
import { Model } from 'mongoose';
import { InvestmentService } from 'src/investment/investment.service';
import { CreatedUserService } from 'src/created-user/created-user.service';
export declare class UsersService {
    private userModel;
    private investmentService;
    private createdUserService;
    uploadPath: string;
    constructor(userModel: Model<UserDocument>, investmentService: InvestmentService, createdUserService: CreatedUserService);
    login(phoneNumber: string): Promise<import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>>;
    loginWithUserPass(userName: string, password: string): Promise<import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>>;
    createUserWithInvestment(type: string, createUserDto: CreateUserDto, documents: Array<{
        title: string;
        sourceDoc: string | Express.Multer.File;
    }>, investments: Array<{
        percent: number;
        time: string;
        amount: number;
    }>): Promise<(import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, import("../created-user/entities/created-user.entity").CreatedUser, {}, {}> & import("../created-user/entities/created-user.entity").CreatedUser & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, import("../created-user/entities/created-user.entity").CreatedUser, {}, {}> & import("../created-user/entities/created-user.entity").CreatedUser & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>) | {
        userExisting: import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        }, {}, {}> & import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        } & Required<{
            _id: import("mongoose").Types.ObjectId;
        }>;
        investmentRegistered: {
            investment: import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, import("../investment/entities/investment.entity").Investment, {}, {}> & import("../investment/entities/investment.entity").Investment & {
                _id: import("mongoose").Types.ObjectId;
            } & {
                __v: number;
            }, {}, {}> & import("mongoose").Document<unknown, {}, import("../investment/entities/investment.entity").Investment, {}, {}> & import("../investment/entities/investment.entity").Investment & {
                _id: import("mongoose").Types.ObjectId;
            } & {
                __v: number;
            } & Required<{
                _id: import("mongoose").Types.ObjectId;
            }>;
            userProvisional: (import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, import("../created-user/entities/created-user.entity").CreatedUser, {}, {}> & import("../created-user/entities/created-user.entity").CreatedUser & {
                _id: import("mongoose").Types.ObjectId;
            } & {
                __v: number;
            }, {}, {}> & import("mongoose").Document<unknown, {}, import("../created-user/entities/created-user.entity").CreatedUser, {}, {}> & import("../created-user/entities/created-user.entity").CreatedUser & {
                _id: import("mongoose").Types.ObjectId;
            } & {
                __v: number;
            } & Required<{
                _id: import("mongoose").Types.ObjectId;
            }>) | null;
        }[];
        user?: undefined;
        userCreated?: undefined;
    } | {
        user: import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        }, {}, {}> & import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        } & Required<{
            _id: import("mongoose").Types.ObjectId;
        }>;
        investmentRegistered: Promise<{
            investment: import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, import("../investment/entities/investment.entity").Investment, {}, {}> & import("../investment/entities/investment.entity").Investment & {
                _id: import("mongoose").Types.ObjectId;
            } & {
                __v: number;
            }, {}, {}> & import("mongoose").Document<unknown, {}, import("../investment/entities/investment.entity").Investment, {}, {}> & import("../investment/entities/investment.entity").Investment & {
                _id: import("mongoose").Types.ObjectId;
            } & {
                __v: number;
            } & Required<{
                _id: import("mongoose").Types.ObjectId;
            }>;
            userProvisional: (import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, import("../created-user/entities/created-user.entity").CreatedUser, {}, {}> & import("../created-user/entities/created-user.entity").CreatedUser & {
                _id: import("mongoose").Types.ObjectId;
            } & {
                __v: number;
            }, {}, {}> & import("mongoose").Document<unknown, {}, import("../created-user/entities/created-user.entity").CreatedUser, {}, {}> & import("../created-user/entities/created-user.entity").CreatedUser & {
                _id: import("mongoose").Types.ObjectId;
            } & {
                __v: number;
            } & Required<{
                _id: import("mongoose").Types.ObjectId;
            }>) | null;
        }>[];
        userExisting?: undefined;
        userCreated?: undefined;
    } | {
        user: import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        }, {}, {}> & import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        } & Required<{
            _id: import("mongoose").Types.ObjectId;
        }>;
        userCreated: import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, import("../created-user/entities/created-user.entity").CreatedUser, {}, {}> & import("../created-user/entities/created-user.entity").CreatedUser & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        }, {}, {}> & import("mongoose").Document<unknown, {}, import("../created-user/entities/created-user.entity").CreatedUser, {}, {}> & import("../created-user/entities/created-user.entity").CreatedUser & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        } & Required<{
            _id: import("mongoose").Types.ObjectId;
        }>;
        userExisting?: undefined;
        investmentRegistered?: undefined;
    }>;
    updateUserWithInvestment(type: string, updateUserDto: UpdateUserDto, documents: Array<{
        title: string;
        sourceDoc: string | Express.Multer.File;
    }>, investments: Array<{
        percent: number;
        time: string;
        type: string;
        amount: number;
    }>): Promise<(import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, import("../created-user/entities/created-user.entity").CreatedUser, {}, {}> & import("../created-user/entities/created-user.entity").CreatedUser & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, import("../created-user/entities/created-user.entity").CreatedUser, {}, {}> & import("../created-user/entities/created-user.entity").CreatedUser & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>) | {
        user: (import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        }, {}, {}> & import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        } & Required<{
            _id: import("mongoose").Types.ObjectId;
        }>) | null;
        investmentRegistered: Promise<import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, import("../investment/entities/investment.entity").Investment, {}, {}> & import("../investment/entities/investment.entity").Investment & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        }, {}, {}> & import("mongoose").Document<unknown, {}, import("../investment/entities/investment.entity").Investment, {}, {}> & import("../investment/entities/investment.entity").Investment & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        } & Required<{
            _id: import("mongoose").Types.ObjectId;
        }>>[];
        deleteUserProvisional: (import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, import("../created-user/entities/created-user.entity").CreatedUser, {}, {}> & import("../created-user/entities/created-user.entity").CreatedUser & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        }, {}, {}> & import("mongoose").Document<unknown, {}, import("../created-user/entities/created-user.entity").CreatedUser, {}, {}> & import("../created-user/entities/created-user.entity").CreatedUser & {
            _id: import("mongoose").Types.ObjectId;
        } & {
            __v: number;
        } & Required<{
            _id: import("mongoose").Types.ObjectId;
        }>) | null;
    } | undefined>;
    searchUser(key: string, value: string, limit: number): Promise<(import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>)[]>;
    users(): Promise<(import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>)[]>;
    usersFindWithCityProvince(city: string, province: string): Promise<(import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>)[]>;
    findUserById(id: string): Promise<import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>>;
    findByPhoneNumber(phoneNumber: string): Promise<(import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>) | null>;
    editUser(id: string, updateUserDto: UpdateUserDto): Promise<import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>>;
    remove(id: string): Promise<import("mongoose").Document<unknown, {}, import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    }, {}, {}> & import("mongoose").Document<unknown, {}, User, {}, {}> & User & {
        _id: import("mongoose").Types.ObjectId;
    } & {
        __v: number;
    } & Required<{
        _id: import("mongoose").Types.ObjectId;
    }>>;
}
