"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UsersService = void 0;
const common_1 = require("@nestjs/common");
const mongoose_1 = require("@nestjs/mongoose");
const user_entity_1 = require("./entities/user.entity");
const mongoose_2 = require("mongoose");
const investment_service_1 = require("../investment/investment.service");
const created_user_service_1 = require("../created-user/created-user.service");
const path_1 = __importDefault(require("path"));
const fs_1 = __importDefault(require("fs"));
const sharp_1 = __importDefault(require("sharp"));
let UsersService = class UsersService {
    userModel;
    investmentService;
    createdUserService;
    uploadPath;
    constructor(userModel, investmentService, createdUserService) {
        this.userModel = userModel;
        this.investmentService = investmentService;
        this.createdUserService = createdUserService;
    }
    async login(phoneNumber) {
        const userExisting = await this.findByPhoneNumber(phoneNumber);
        if (!userExisting) {
            throw new common_1.BadRequestException('کاربر مورد نظر یافت نشد');
        }
        return userExisting;
    }
    async loginWithUserPass(userName, password) {
        const existingUser = await this.userModel.findOne({ userName, password });
        if (!existingUser) {
            throw new common_1.BadRequestException('کاربر مورد نظر یافت نشد');
        }
        return existingUser;
    }
    async createUserWithInvestment(type, createUserDto, documents, investments) {
        const uploadPath = path_1.default.join("/home/lovelybu/files.tda24.ir/tiafiles/users");
        const userExisting = await this.userModel.findOne({ phoneNumber: createUserDto.phoneNumber });
        if (userExisting != undefined) {
            console.log('userExisting:', userExisting, documents);
            console.log('userExisting._id:', userExisting?._id);
            if (userExisting?.documents != undefined) {
                console.log('documents', documents);
                const imagePath = path_1.default.join(uploadPath, userExisting._id.toString());
                console.log(imagePath);
                if (!fs_1.default.existsSync(imagePath)) {
                    fs_1.default.mkdirSync(imagePath, { recursive: true, mode: 0o755 });
                }
                let documentsUser = await Promise.all(documents.map(async (doc) => {
                    if (doc?.sourceDoc != undefined && !((typeof doc.sourceDoc) === 'string')) {
                        const randomNumber = Math.floor(Math.random() * 100000);
                        const fileName = `document-${randomNumber}.webp`;
                        const filePath = path_1.default.join(imagePath, fileName);
                        console.log("buffer", doc.sourceDoc.buffer.length);
                        try {
                            await (0, sharp_1.default)(doc.sourceDoc.buffer)
                                .resize(300, 300)
                                .toFormat('webp')
                                .toFile(filePath);
                            console.log('File saved successfully!');
                        }
                        catch (err) {
                            console.error('Sharp error:', err);
                        }
                        console.log('Saving file to:', filePath);
                        await fs_1.default.promises.chmod(filePath, 0o644);
                        return { title: doc.title, sourceDoc: `${process.env.FILES_URL}/uploads/users/${userExisting._id}/${fileName}` };
                    }
                    else {
                        return doc;
                    }
                }));
                userExisting.documents = documentsUser;
            }
            await userExisting.save();
            if (investments.length != 0) {
                const investmentRegistered = await Promise.all(investments.map(async (item) => {
                    const result = await this.investmentService.createInvestment(String(userExisting._id), item.percent, item.time, type, item.amount);
                    return result;
                }));
                return { userExisting, investmentRegistered };
            }
            else {
                const userCreated = await this.createdUserService.createUserProvisional(String(userExisting._id), type);
                return userCreated;
            }
        }
        else {
            const user = await this.userModel.create(createUserDto);
            if (!user)
                throw new common_1.BadRequestException('خطا در ایجاد کاربر');
            if (user?.documents != undefined) {
                const imagePath = path_1.default.join(uploadPath, String(user._id));
                await fs_1.default.promises.mkdir(imagePath, { recursive: true, mode: 0o755 });
                let documentsUser = await Promise.all(documents.map(async (doc) => {
                    if (!((typeof doc.sourceDoc) === 'string')) {
                        const randomNumber = Math.floor(Math.random() * 100000);
                        const fileName = `document-${randomNumber}.webp`;
                        const filePath = path_1.default.join(imagePath, fileName);
                        await (0, sharp_1.default)(doc.sourceDoc.buffer).resize(300, 300).toFormat('webp').toFile(filePath);
                        await fs_1.default.promises.chmod(filePath, 0o644);
                        return { title: doc.title, sourceDoc: `${process.env.FILES_URL}/uploads/users/${user._id}/${fileName}` };
                    }
                    else {
                        return doc;
                    }
                }));
                user.documents = documentsUser;
            }
            if (investments.length != 0) {
                const investmentRegistered = investments.map(async (item) => {
                    const result = await this.investmentService.createInvestment(String(user._id), item.percent, item.time, type, item.amount);
                    return result;
                });
                return { user, investmentRegistered };
            }
            else {
                const userCreated = await this.createdUserService.createUserProvisional(String(user._id), type);
                return { user, userCreated };
            }
        }
    }
    async updateUserWithInvestment(type, updateUserDto, documents, investments) {
        console.log(investments);
        const userExisting = await this.findByPhoneNumber(updateUserDto.phoneNumber);
        const uploadPath = path_1.default.join("/home/lovelybu/files.tda24.ir/tiafiles/users");
        if (userExisting) {
            const user = await this.userModel.findByIdAndUpdate(userExisting._id, updateUserDto);
            if (userExisting?.documents != undefined) {
                console.log('documents', documents);
                const imagePath = path_1.default.join(uploadPath, userExisting._id.toString());
                console.log(imagePath);
                if (!fs_1.default.existsSync(imagePath)) {
                    fs_1.default.mkdirSync(imagePath, { recursive: true, mode: 0o755 });
                }
                let documentsUser = await Promise.all(documents.map(async (doc) => {
                    if (doc?.sourceDoc != undefined && !((typeof doc.sourceDoc) === 'string')) {
                        const randomNumber = Math.floor(Math.random() * 100000);
                        const fileName = `document-${randomNumber}.webp`;
                        const filePath = path_1.default.join(imagePath, fileName);
                        console.log("buffer", doc.sourceDoc.buffer.length);
                        try {
                            await (0, sharp_1.default)(doc.sourceDoc.buffer)
                                .resize(300, 300)
                                .toFormat('webp')
                                .toFile(filePath);
                            console.log('File saved successfully!');
                        }
                        catch (err) {
                            console.error('Sharp error:', err);
                        }
                        console.log('Saving file to:', filePath);
                        await fs_1.default.promises.chmod(filePath, 0o644);
                        return { title: doc.title, sourceDoc: `${process.env.FILES_URL}/uploads/users/${userExisting._id}/${fileName}` };
                    }
                    else {
                        return doc;
                    }
                }));
                userExisting.documents = documentsUser;
            }
            await userExisting.save();
            if (investments.length != 0) {
                const investmentRegistered = investments.map(async (item) => {
                    console.log(item);
                    const result = await this.investmentService.updateInvestment(item.id, String(userExisting._id), item.percent, item.time, type, item.amount);
                    return result;
                });
                const deleteUserProvisional = await this.createdUserService.deleteWithUserId(String(userExisting._id), type);
                return { user, investmentRegistered, deleteUserProvisional };
            }
            else {
                const userCreated = await this.createdUserService.createUserProvisional(String(userExisting._id), type);
                return userCreated;
            }
        }
    }
    async searchUser(key, value, limit) {
        const keysAllowed = ['fullName', 'nationalCode', "phoneNumber"];
        if (!keysAllowed.includes(key))
            throw new common_1.BadRequestException('خطا در جستجوی کاربر کلید مورد نظر یافت نشد!');
        const user = await this.userModel.find({ [key]: { $regex: value, $options: 'i' } }).limit(limit);
        if (!user)
            throw new common_1.NotFoundException('کاربر مورد نظر یافت نشد!');
        return user;
    }
    async users() {
        return await this.userModel.find().sort({ createdAt: -1 }).limit(10);
    }
    async usersFindWithCityProvince(city, province) {
        return await this.userModel.find({ city, province });
    }
    async findUserById(id) {
        const user = await this.userModel.findById(id).exec();
        if (!user)
            throw new common_1.NotFoundException('کاربر مورد نظر یافت نشد');
        return user;
    }
    async findByPhoneNumber(phoneNumber) {
        const existingUser = await this.userModel.findOne({ phoneNumber });
        return existingUser;
    }
    async editUser(id, updateUserDto) {
        const user = await this.userModel.findByIdAndUpdate(id, updateUserDto);
        if (!user)
            throw new common_1.NotFoundException('کاربر مورد نظر یافت نشد');
        return user;
    }
    async remove(id) {
        const user = await this.userModel.findByIdAndDelete(id);
        if (!user)
            throw new common_1.NotFoundException('کاربر مورد نظر یافت نشد');
        return user;
    }
};
exports.UsersService = UsersService;
exports.UsersService = UsersService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, mongoose_1.InjectModel)(user_entity_1.User.name)),
    __metadata("design:paramtypes", [mongoose_2.Model,
        investment_service_1.InvestmentService, created_user_service_1.CreatedUserService])
], UsersService);
//# sourceMappingURL=users.service.js.map